<?= view('layout/header') ?>

<style>
    .hero-section {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        padding: 60px 0;
        margin: -20px -15px 40px -15px;
        color: white;
        position: relative;
        overflow: hidden;
    }

    .hero-section::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg"><circle cx="50" cy="50" r="2" fill="white" opacity="0.1"/></svg>');
        animation: float 20s linear infinite;
    }

    @keyframes float {
        0% { transform: translateY(0); }
        100% { transform: translateY(-100px); }
    }

    .hero-content {
        position: relative;
        z-index: 1;
    }

    .hero-title {
        font-size: 3rem;
        font-weight: 800;
        margin-bottom: 10px;
        text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
    }

    .hero-subtitle {
        font-size: 1.3rem;
        opacity: 0.95;
        font-weight: 300;
    }

    .menu-card {
        border: none;
        border-radius: 20px;
        transition: all 0.4s ease;
        background: white;
        overflow: hidden;
        position: relative;
        height: 280px;
        cursor: pointer;
    }

    .menu-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 5px;
        transition: height 0.4s ease;
    }

    .menu-card:hover::before {
        height: 100%;
        opacity: 0.1;
    }

    .menu-card.biodata::before {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }

    .menu-card.pendidikan::before {
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    }

    .menu-card.aktivitas::before {
        background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    }

    .menu-card:hover {
        transform: translateY(-15px);
        box-shadow: 0 20px 40px rgba(0,0,0,0.15);
    }

    .card-icon {
        font-size: 4rem;
        margin: 0px 0 20px 0;
        transition: transform 0.4s ease;
    }

    .menu-card:hover .card-icon {
        transform: scale(1.1) rotate(5deg);
    }

    .menu-card h5 {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 15px;
        position: relative;
        z-index: 1;
    }

    .menu-card p {
        color: #6c757d;
        font-size: 0.95rem;
        margin-bottom: 25px;
        position: relative;
        z-index: 1;
    }

    .btn-custom {
        padding: 12px 35px;
        border-radius: 25px;
        font-weight: 600;
        border: none;
        transition: all 0.3s ease;
        position: relative;
        z-index: 1;
        text-transform: uppercase;
        letter-spacing: 1px;
        font-size: 0.85rem;
    }

    .btn-biodata {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
    }

    .btn-biodata:hover {
        transform: scale(1.05);
        box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        color: white;
    }

    .btn-pendidikan {
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        color: white;
    }

    .btn-pendidikan:hover {
        transform: scale(1.05);
        box-shadow: 0 5px 15px rgba(240, 147, 251, 0.4);
        color: white;
    }

    .btn-aktivitas {
        background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
        color: white;
    }

    .btn-aktivitas:hover {
        transform: scale(1.05);
        box-shadow: 0 5px 15px rgba(79, 172, 254, 0.4);
        color: white;
    }

    .container-custom {
        max-width: 1200px;
        max-height: 500px;
        margin: 0 auto;
        padding: 0 15px;
    }

    @media (max-width: 768px) {
        .hero-title {
            font-size: 2rem;
        }
        .hero-subtitle {
            font-size: 1rem;
        }
        .menu-card {
            margin-bottom: 20px;
        }
    }
</style>

<div class="hero-section">
    <div class="hero-content text-center">
        <h1 class="hero-title">Curriculum Vitae</h1>
        <p class="hero-subtitle">Shofie Sholeha</p>
    </div>
</div>

<div class="container-custom">
    <div class="row g-6">
        <div class="col-md-4">
            <div class="card menu-card biodata shadow-sm text-center">
                <div class="card-body d-flex flex-column justify-content-center align-items-center">
                    <div class="card-icon">👤</div>
                    <h5>Biodata Pribadi</h5>
                    <p>Informasi lengkap tentang data diri dan kontak</p>
                    <a href="<?= base_url('biodata') ?>" class="btn btn-biodata btn-custom">Lihat Detail</a>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card menu-card pendidikan shadow-sm text-center">
                <div class="card-body d-flex flex-column justify-content-center align-items-center">
                    <div class="card-icon">🎓</div>
                    <h5>Riwayat Pendidikan</h5>
                    <p>Perjalanan pendidikan formal yang telah ditempuh</p>
                    <a href="<?= base_url('pendidikan') ?>" class="btn btn-pendidikan btn-custom">Lihat Detail</a>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card menu-card aktivitas shadow-sm text-center">
                <div class="card-body d-flex flex-column justify-content-center align-items-center">
                    <div class="card-icon">⚡</div>
                    <h5>Aktivitas & Prestasi</h5>
                    <p>Kegiatan organisasi dan pencapaian yang diraih</p>
                    <a href="<?= base_url('aktivitas') ?>" class="btn btn-aktivitas btn-custom">Lihat Detail</a>
                </div>
            </div>
        </div>
    </div>
</div>

<div style="margin-bottom: 40px;"></div>

<?= view('layout/footer') ?>